/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.usercleanup.v2;

import com.atlassian.annotations.PublicApi;
import com.atlassian.config.ConfigurationException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.kantega.atlaskerb.hostapp.CleanupHostApp;
import org.kantega.atlaskerb.hostapp.CleanupHostAppFactoryV2;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.utils.CleanupMode;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.RunAttributes;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v2.jsoncreatorclasses.CleanupRuleDTOV2;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v2.jsoncreatorclasses.UserCleanupResultV2;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v2.jsoncreatorclasses.UserSummaryV2;
import org.kantega.atlaskerb.rest.util.ResponseUtils;
import org.kantega.atlaskerb.usercleanup.CleanupStatus;
import org.kantega.atlaskerb.usercleanup.CleanupUtilsShared;
import org.kantega.atlaskerb.usercleanup.v2.BlockedResourceException;
import org.kantega.atlaskerb.usercleanup.v2.config.model.CleanupSchedulesAoService;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="execute")
@PublicApi
public class ExecuteV2 {
    private static final Logger log = LoggerFactory.getLogger(ExecuteV2.class);
    private final UserManager userManager;
    private final CleanupHostApp<UserCleanupResultV2> hostApp;
    private final JsonWrapper jsonWrapper;
    private final CleanupSchedulesAoService cleanupSchedulesAoService;

    @Inject
    public ExecuteV2(@ComponentImport UserManager userManager, CleanupHostAppFactoryV2 hostAppFactory, JsonWrapper jsonWrapper, CleanupSchedulesAoService cleanupSchedulesAoService) {
        this.userManager = userManager;
        this.hostApp = hostAppFactory.getInstance();
        this.jsonWrapper = jsonWrapper;
        this.cleanupSchedulesAoService = cleanupSchedulesAoService;
    }

    private void setSameCleanupModeLastRunId(CleanupMode cleanupMode, String runId) {
        if (cleanupMode.equals((Object)CleanupMode.JSM)) {
            this.hostApp.setJsmCleanupLastRunId(runId);
        } else {
            this.hostApp.setUserCleanupLastRunId(runId);
        }
    }

    private void setSameCleanupModeExecuteStatus(CleanupMode cleanupMode, CleanupStatus newStatus) {
        if (cleanupMode.equals((Object)CleanupMode.JSM)) {
            this.hostApp.setJsmCleanupExecuteStatus(newStatus);
        } else {
            this.hostApp.setUserCleanupExecuteStatus(newStatus);
        }
    }

    private boolean isSameCleanupModeRunning(RunAttributes runAttributes) {
        CleanupMode cleanupMode = CleanupUtilsShared.getCleanupMode(runAttributes);
        if (cleanupMode.equals((Object)CleanupMode.JSM)) {
            return this.hostApp.getJsmCleanupExecuteStatus().equals((Object)CleanupStatus.RUNNING);
        }
        return this.hostApp.getUserCleanupExecuteStatus().equals((Object)CleanupStatus.RUNNING);
    }

    private Response run(UserProfile userProfile, String id, RunAttributes runAttributes) {
        UUID runUUID = UUID.randomUUID();
        DateTime runStartTime = DateTime.now();
        boolean dryRun = runAttributes.isDryRun();
        String username = userProfile.getUsername();
        Option jobRunnerKey = Option.of((Object)this.cleanupSchedulesAoService.getScheduledCleanupRule(id)).map(CleanupRuleDTOV2::getJobRunnerKey).filter(StringUtils::isNotEmpty);
        if (jobRunnerKey.isEmpty()) {
            log.error("No cleanup rule found for id: " + id);
            return Response.serverError().build();
        }
        Future<?> submitted = this.hostApp.getInactiveUserCleaner().getWorkers().submit(new CleanupRunnable((String)jobRunnerKey.get(), runUUID, runStartTime, runAttributes, username));
        UserCleanupResultV2 result = new UserCleanupResultV2(runUUID.toString(), runUUID.toString(), "no.kantega.usermanagement:" + runUUID.toString(), runStartTime.toString(), dryRun, runAttributes.isSimulateCronDate(), new UserSummaryV2[0], null, new String[0], new String[0], -1, -1, -1);
        return (Response)this.jsonWrapper.tryBuildJsonString(result).map(jsonString -> Response.ok((Object)jsonString, (MediaType)MediaType.APPLICATION_JSON_TYPE).build()).onFailure(throwable -> log.error("Failed to build JSON: ", throwable)).getOrElse((Object)Response.serverError().build());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    public Response doPost(@Context HttpServletRequest request, @PathParam(value="id") String id, RunAttributes runAttributes) {
        return ResponseUtils.sysadminOnly(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)userProfile -> (Response)Try.of((CheckedFunction0 & Serializable)() -> this.run((UserProfile)userProfile, id, runAttributes)).onFailure(e -> log.error("Encountered an exception while attempting to cleanup users. ", e)).getOrElse((Object)Response.serverError().build()));
    }

    class CleanupRunnable
    implements Runnable {
        private final String jobRunnerKey;
        private final UUID runId;
        private final DateTime runStartTime;
        private final RunAttributes runAttributes;
        private final String username;
        private final CleanupMode cleanupMode;

        public CleanupRunnable(String jobRunnerKey, UUID runId, DateTime runStartTime, RunAttributes runAttributes, String username) {
            this.jobRunnerKey = jobRunnerKey;
            this.runId = runId;
            this.runStartTime = runStartTime;
            this.runAttributes = runAttributes;
            this.username = username;
            this.cleanupMode = CleanupUtilsShared.getCleanupMode(runAttributes);
        }

        @Override
        public void run() {
            try {
                ExecuteV2.this.hostApp.preCallForThreadLocal();
                String threadName = Thread.currentThread().getName();
                long threadId = Thread.currentThread().getId();
                log.info(String.format("User cleanup thread starting at %s %s %d %s", this.runStartTime.toString(), threadName, threadId, this.runId));
                ExecuteV2.this.setSameCleanupModeExecuteStatus(this.cleanupMode, CleanupStatus.RUNNING);
                ExecuteV2.this.setSameCleanupModeLastRunId(this.cleanupMode, this.runId.toString());
                ExecuteV2.this.hostApp.cleanupInactiveUsersV2(this.jobRunnerKey, this.username, this.runAttributes != null ? this.runAttributes : new RunAttributes(false, false, false), this.runStartTime, this.runId.toString());
                ExecuteV2.this.setSameCleanupModeExecuteStatus(this.cleanupMode, CleanupStatus.SUCCESS);
            }
            catch (ConfigurationException e) {
                log.error("User cleanup failed", (Throwable)e);
                ExecuteV2.this.setSameCleanupModeExecuteStatus(this.cleanupMode, CleanupStatus.FAILED);
            }
            catch (InterruptedException | BlockedResourceException e) {
                ExecuteV2.this.setSameCleanupModeExecuteStatus(this.cleanupMode, CleanupStatus.FAILED);
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                log.error("User cleanup failed", (Throwable)e);
                ExecuteV2.this.setSameCleanupModeExecuteStatus(this.cleanupMode, CleanupStatus.FAILED);
                throw new RuntimeException(e);
            }
            finally {
                org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(ExecuteV2.class);
                ExecuteV2.this.hostApp.postCallForCleanupThreadLocal(logger);
            }
        }
    }
}

