/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.jobs;

import com.atlassian.config.ConfigurationException;
import com.atlassian.extras.api.LicenseException;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.kantega.atlaskerb.hostapp.CleanupHostApp;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.RunAttributes;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v2.jsoncreatorclasses.UserCleanupResultV2;
import org.kantega.atlaskerb.usercleanup.v2.BlockedResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserCleanupJobRunnerV2
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(UserCleanupJobRunnerV2.class);
    private CleanupHostApp<UserCleanupResultV2> hostApp;

    @Autowired
    public void setHostApp(CleanupHostApp<UserCleanupResultV2> cleanupHostApp) {
        this.hostApp = cleanupHostApp;
    }

    @Inject
    public UserCleanupJobRunnerV2() {
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        try {
            if (this.hostApp.isProductInReadOnlyMode()) {
                log.warn("Product is in read-only mode. Skipping UserCleanup job.");
                return JobRunnerResponse.aborted((String)"Product is in read-only mode. Skipping UserCleanup job.");
            }
            log.info("UserCleanup: Starting scheduled run");
            UserCleanupResultV2 result = this.hostApp.cleanupInactiveUsersV2(jobRunnerRequest.getJobConfig().getJobRunnerKey().toString(), null, new RunAttributes(false, false, false), DateTime.now(), UUID.randomUUID().toString());
            if (result != null) {
                log.info("UserCleanup: Scheduled run with runID {} succeeded", (Object)result.getRunId());
                return JobRunnerResponse.success((String)String.format("User cleanup with runID %s completed.", result.getRunId()));
            }
            log.warn("UserCleanup: Scheduled run failed. No result..");
            return JobRunnerResponse.failed((String)"User cleanup failed. No result..");
        }
        catch (ConfigurationException e) {
            log.error("UserCleanup: Scheduled run failed. Bad configuration: ", (Throwable)e);
            return JobRunnerResponse.failed((Throwable)e);
        }
        catch (BlockedResourceException e) {
            log.warn("UserCleanup: Scheduled run did not start since a cleanup is already running");
            return JobRunnerResponse.aborted((String)"Cleanup already running. Aborted.");
        }
        catch (InterruptedException e) {
            log.error("UserCleanup: Scheduled run failed, thread interrupted");
            return JobRunnerResponse.failed((Throwable)e);
        }
        catch (LicenseException e) {
            log.error("UserCleanup: Scheduled run failed, license not valid or expired");
            return JobRunnerResponse.failed((Throwable)e);
        }
    }
}

