/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.jobs;

import com.atlassian.config.ConfigurationException;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobRunnerKey;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.kantega.atlaskerb.hostapp.CleanupHostApp;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.RunAttributes;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.UserCleanupResultV1;
import org.kantega.atlaskerb.usercleanup.CleanupStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserCleanupJobRunner
implements JobRunner {
    public static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)(UserCleanupJobRunner.class + ".job"));
    private static final Logger log = LoggerFactory.getLogger(UserCleanupJobRunner.class);
    private CleanupHostApp<UserCleanupResultV1> hostApp;

    @Autowired
    public void setHostApp(CleanupHostApp<UserCleanupResultV1> cleanupHostApp) {
        this.hostApp = cleanupHostApp;
    }

    @Inject
    public UserCleanupJobRunner() {
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        try {
            if (this.hostApp.isProductInReadOnlyMode()) {
                log.warn("Product is in read-only mode. Skipping UserCleanup job.");
                return JobRunnerResponse.aborted((String)"Product is in read-only mode. Skipping UserCleanup job.");
            }
            log.info(String.format("UserCleanup: Starting scheduled run, previous CleanupStatus is %s", this.hostApp.getUserCleanupExecuteStatus().toString()));
            if (this.hostApp.getUserCleanupExecuteStatus() == CleanupStatus.RUNNING) {
                log.warn(String.format("UserCleanup: Scheduled run did not start since a cleanup is already running, CleanupStatus is %s", this.hostApp.getUserCleanupExecuteStatus().toString()));
                return JobRunnerResponse.aborted((String)"Cleanup already running");
            }
            this.hostApp.setUserCleanupExecuteStatus(CleanupStatus.RUNNING);
            this.hostApp.cleanupInactiveUsers(null, new RunAttributes(false, false, false), DateTime.now(), UUID.randomUUID().toString());
        }
        catch (ConfigurationException e) {
            this.hostApp.setUserCleanupExecuteStatus(CleanupStatus.FAILED);
            log.error(String.format("UserCleanup: Scheduled run failed, current CleanupStatus is %s", this.hostApp.getUserCleanupExecuteStatus().toString()));
            return JobRunnerResponse.failed((Throwable)e);
        }
        this.hostApp.setUserCleanupExecuteStatus(CleanupStatus.SUCCESS);
        log.info(String.format("UserCleanup: Scheduled run succeeded, current CleanupStatus is %s", this.hostApp.getUserCleanupExecuteStatus().toString()));
        return JobRunnerResponse.success();
    }
}

