/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.backup;

import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.RequireAdminServletCleanup;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucketCleanup;
import org.kantega.atlaskerb.backup.BackupService;

public class BackupAction
extends RequireAdminServletCleanup {
    private final BackupService backupService;
    private final TemplateRenderer renderer;

    @Inject
    public BackupAction(RequireAdminServletDependencyBucketCleanup bucket, BackupService backupService) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.backupService = backupService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        this.renderPage(resp, model);
    }

    private void renderPage(HttpServletResponse resp, Map<String, Object> model) throws IOException {
        resp.setContentType("text/html");
        model.put("topMenu", "dashboard");
        model.put("menuItem", "backup");
        this.renderer.render("templates/atlaskerb/backup/backup-uc.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getParameter("create") != null) {
            this.backupService.createBackup(req.getParameter("description"));
        }
        resp.sendRedirect("backup");
    }
}

