/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServletCleanup;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucketCleanup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InactiveUserCleanupPremiumAction
extends RequireAdminServletCleanup {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final Logger log = LoggerFactory.getLogger(InactiveUserCleanupPremiumAction.class);

    @Inject
    public InactiveUserCleanupPremiumAction(RequireAdminServletDependencyBucketCleanup bucket, @ComponentImport PluginAccessor pluginAccessor) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType("text/html");
        resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
        Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "dashboard");
        model.put("menuItem", "inactiveUserCleanupPremium");
        String contextPath = req.getContextPath();
        model.put("contextPath", contextPath);
        try {
            Object pluginLicense = this.kerbConfManager.getLicenseManager().getLicense().get();
            if (pluginLicense != null) {
                model.put("pluginLicense_active", String.valueOf(this.getField(pluginLicense, "active")));
                model.put("pluginLicense_pluginName", String.valueOf(this.getField(pluginLicense, "pluginName")));
                Object expiryDate = this.getField(pluginLicense, "expiryDate");
                String expiryDateStr = String.valueOf(expiryDate);
                model.put("pluginLicense_expiryDate", expiryDateStr != null ? expiryDateStr : "N/A");
                Object licenseType = this.getField(pluginLicense, "licenseType");
                String licenseTypeStr = String.valueOf(licenseType);
                model.put("pluginLicense_licenseType", licenseTypeStr != null ? licenseTypeStr : "N/A");
                Object error = this.getField(pluginLicense, "error");
                String errorStr = String.valueOf(error);
                model.put("pluginLicense_error", errorStr != null ? errorStr : "N/A");
                model.put("pluginLicense_evaluation", String.valueOf(this.getField(pluginLicense, "evaluation")));
                model.put("pluginLicense_description", String.valueOf(this.getField(pluginLicense, "description")));
            }
            model.put("licenseValid", this.getField(pluginLicense, "active"));
            model.put("isProductInReadOnlyMode", this.hostApp.isProductInReadOnlyMode());
        }
        catch (Exception e) {
            this.log.error("Error getting license", (Throwable)e);
        }
        model.put("displayName", this.applicationProperties.getDisplayName());
        Properties buildInfo = KerbConfManager.getBuildInfo();
        model.put("version", buildInfo.getProperty("build.version"));
        model.put("buildDate", buildInfo.getProperty("build.date"));
        String kssoBuildPipelineId = buildInfo.getProperty("ksso.build.pipeline.id");
        String kssoBuildPipelineUrl = buildInfo.getProperty("ksso.build.pipeline.url");
        model.put("kssoBuildPipelineId", StringUtils.isNotBlank((CharSequence)kssoBuildPipelineId) ? kssoBuildPipelineId : null);
        model.put("kssoBuildPipelineUrl", StringUtils.isNotBlank((CharSequence)kssoBuildPipelineUrl) ? kssoBuildPipelineUrl : null);
        this.getTemplateRenderer().render("templates/common/disable-inactive-users-premium.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        super.doPost(req, resp);
        resp.sendRedirect("userCleanup/inactiveUserCleanup");
    }

    private Object getField(Object obj, String fieldName) {
        try {
            Field field = obj.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(obj);
        }
        catch (Exception e) {
            return null;
        }
    }
}

