/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.usercleanup.utils;

import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;

public enum CleanupMode {
    USERS("USERS"),
    JSM("JSM"),
    JSMEMAIL("JSMEMAIL"),
    JSMSIGNUP("JSMSIGNUP"),
    JSMEXTERNAL("JSMEXTERNAL");

    private final String value;

    private CleanupMode(String alias) {
        this.value = alias;
    }

    public String getValue() {
        return this.value;
    }

    public static Try<CleanupMode> parse(String s) {
        return Try.of((CheckedFunction0 & Serializable)() -> {
            if (CleanupMode.USERS.value.equals(s)) {
                return USERS;
            }
            if (CleanupMode.JSM.value.equals(s)) {
                return JSM;
            }
            if (CleanupMode.JSMEMAIL.value.equals(s)) {
                return JSMEMAIL;
            }
            if (CleanupMode.JSMSIGNUP.value.equals(s)) {
                return JSMSIGNUP;
            }
            if (CleanupMode.JSMEXTERNAL.value.equals(s)) {
                return JSMEXTERNAL;
            }
            throw new IllegalArgumentException("Invalid cleanup mode: " + s);
        });
    }

    public boolean isEqualTo(String s) {
        return (Boolean)CleanupMode.parse(s).map(c -> c == this).getOrElse((Object)false);
    }
}

