/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.hostapp;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.config.ConfigurationException;
import com.atlassian.crowd.directory.DbCachingRemoteDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.application.ApplicationAuthorizationService;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleAdminService;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizUser;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.jira.license.LicenseCountService;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.JiraImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.AuthenticationController;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.license.MultiProductLicenseDetails;
import com.atlassian.sal.api.license.ProductLicense;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.hostapp.DefaultCleanupHostApp;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.utils.CleanupMode;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.UnifiedLicenseInfo;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.CleanupRuleDTOV1;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.RunAttributes;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.UserCleanupResultV1;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.UserSummary;
import org.kantega.atlaskerb.usercleanup.BreakException;
import org.kantega.atlaskerb.usercleanup.CleanupStatus;
import org.kantega.atlaskerb.usercleanup.InactiveUserCleaner;
import org.kantega.atlaskerb.utils.CryptoUtils;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.kantega.atlaskerb.utils.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@JiraComponent
public class JiraCleanupHostApp<U extends UserCleanupResultV1>
extends DefaultCleanupHostApp<U> {
    private static final String COMMENT_REST_URL = "/rest/api/2/issue/.*/comment";
    private static final String COMMENT_POST_URL = "/secure/AddComment.jspa";
    private final Method recordLoginMethod;
    private final Object loginComponent;
    private final Method fromUser;
    ApplicationRoleManager applicationRoleManager;
    private final UserManager userManager;
    private final Logger log;
    private boolean useApplicationUser;
    @JiraImport
    private ApplicationRoleAdminService applicationRoleAdminService;
    @JiraImport
    LicenseCountService licenseCountService;
    @JiraImport
    private LicenseHandler licenseHandler;
    private Class<?> beforeUserAuthenticateClass;

    public UserManager getUserManager() {
        return this.userManager;
    }

    @Autowired
    public void setApplicationRoleManager() {
        this.applicationRoleManager = (ApplicationRoleManager)ComponentLocator.getComponent(ApplicationRoleManager.class);
    }

    @Autowired
    public void setLicenseCountService(LicenseCountService licenseCountService) {
        this.licenseCountService = licenseCountService;
    }

    @Autowired
    public void setLicenseHandler(LicenseHandler licenseHandler) {
        this.licenseHandler = licenseHandler;
    }

    @Autowired
    public void setApplicationRoleAdminService(ApplicationRoleAdminService applicationRoleAdminService) {
        this.applicationRoleAdminService = applicationRoleAdminService;
    }

    public JiraCleanupHostApp(@ComponentImport TransactionTemplate transactionTemplate, ApplicationProperties applicationProperties, @ComponentImport AuthenticationListener authenticationListener, @ComponentImport EventPublisher eventPublisher, @ComponentImport AuthenticationController authenticationController, @ComponentImport CrowdDirectoryService crowdDirectoryService, @ComponentImport CrowdService crowdService, KerbConfManager kerbConfManager, JsonWrapper jsonWrapper) {
        Method fromUser;
        Object loginComponent;
        Method recordLoginMethod;
        block4: {
            super(transactionTemplate, applicationProperties, authenticationListener, eventPublisher, authenticationController, crowdDirectoryService, crowdService, kerbConfManager, jsonWrapper);
            this.log = LoggerFactory.getLogger(this.getClass());
            this.beforeUserAuthenticateClass = null;
            recordLoginMethod = null;
            loginComponent = null;
            fromUser = null;
            this.userManager = ComponentAccessor.getUserManager();
            try {
                ClassLoader ccl = this.getClass().getClassLoader().getParent();
                if (ccl == null) break block4;
                Class<?> loginStoreClass = ccl.loadClass("com.atlassian.jira.security.login.LoginStore");
                Class<?> applicationUserClass = ccl.loadClass("com.atlassian.jira.user.ApplicationUser");
                Class<?> applicationUsersClass = ccl.loadClass("com.atlassian.jira.user.ApplicationUsers");
                Class<User> crowdEmbeddedUserClass = User.class;
                this.beforeUserAuthenticateClass = ccl.loadClass("com.atlassian.jira.event.user.BeforeUserAuthenticate");
                try {
                    recordLoginMethod = loginStoreClass.getMethod("recordLoginAttempt", applicationUserClass, Boolean.TYPE);
                    this.useApplicationUser = true;
                    fromUser = applicationUsersClass.getMethod("from", User.class);
                }
                catch (NoSuchMethodException e) {
                    recordLoginMethod = loginStoreClass.getMethod("recordLoginAttempt", crowdEmbeddedUserClass, Boolean.TYPE);
                    this.useApplicationUser = false;
                }
                loginComponent = ComponentLocator.getComponent(loginStoreClass);
            }
            catch (Exception e) {
                this.log.warn("Could not load JIRA LoginStore. Login count / time update disabled", (Throwable)e);
            }
        }
        this.recordLoginMethod = recordLoginMethod;
        this.loginComponent = loginComponent;
        this.fromUser = fromUser;
    }

    private boolean isRootRequest(HttpServletRequest req) {
        return req.getRequestURI().equals(req.getContextPath() + "/");
    }

    @Override
    public boolean isProductMatch(String product) {
        return StringUtils.equalsIgnoreCase((CharSequence)"jira", (CharSequence)product);
    }

    @Override
    public boolean urlInAdditionalBuiltInApiRequest(HttpServletRequest req) {
        return StringUtils.startsWith((CharSequence)HttpUrlUtils.getInternalPath(req), (CharSequence)"/sr/jira.issueviews");
    }

    @Override
    public boolean isPageWithLoginForm(HttpServletRequest req) {
        String requestUri = HttpUrlUtils.getInternalPath(req);
        return this.isMainLoginPage(req) || requestUri.equalsIgnoreCase("/secure/Dashboard.jspa") || requestUri.equals("/Dashboard.jspa") || requestUri.equals("/secure/MyJiraHome.jspa") || requestUri.equals("/secure/") || this.isRootRequest(req) || this.kerbConfManager.isKerberosJsmEnabled() && JiraCleanupHostApp.isJSMLoginPage(req) && !this.isServiceDeskLogout(req) || this.kerbConfManager.isUserdetailsInCommentsEnabled() && (requestUri.matches(COMMENT_REST_URL) || requestUri.startsWith(COMMENT_POST_URL));
    }

    @Override
    public boolean isMainLoginPage(HttpServletRequest request) {
        String internalPath = HttpUrlUtils.getInternalPath(request);
        return internalPath.equals("/login.jsp") || JiraCleanupHostApp.isJSMLoginPage(internalPath);
    }

    @Override
    public boolean isServiceDeskLogout(HttpServletRequest r) {
        return JiraCleanupHostApp.isJSMLoginPage(r) && StringUtils.equals((CharSequence)r.getParameter("logout"), (CharSequence)"true") || HttpUrlUtils.getInternalPath(r).equals("/servicedesk/customer/user/logout");
    }

    private boolean isGadgetLoginRequest(HttpServletRequest req, String r) {
        return r.startsWith("/rest/gadget/") && r.endsWith("/login") && "POST".equals(req.getMethod());
    }

    private boolean isForwardedServiceDesk(HttpServletRequest req) {
        String forwardedUri = (String)req.getAttribute("javax.servlet.forward.request_uri");
        if (forwardedUri == null) {
            return false;
        }
        return JiraCleanupHostApp.isJSMLoginPage(forwardedUri.substring(req.getContextPath().length()));
    }

    public static boolean isJSMLoginPage(HttpServletRequest req) {
        return JiraCleanupHostApp.isJSMLoginPage(HttpUrlUtils.getInternalPath(req));
    }

    public static boolean isJSMLoginPage(String requestPath) {
        return requestPath.startsWith("/servicedesk/customer/") && requestPath.endsWith("/user/login") || requestPath.equals("/servicedesk/customer/user/login");
    }

    @Override
    public String optionallyDecryptLdapPassword(String ldapPasswordParameter) {
        if (CryptoUtils.secretIndicatesEncryptedValue(ldapPasswordParameter)) {
            String encryptorClassName = "com.atlassian.jira.crowd.embedded.encryptors.JiraEncryptor";
            String componentManagerClassName = "com.atlassian.jira.component.pico.ComponentManager";
            return (String)this.decryptLdapPassword(ldapPasswordParameter, "com.atlassian.jira.crowd.embedded.encryptors.JiraEncryptor", "com.atlassian.jira.component.pico.ComponentManager").getOrElse((Object)ldapPasswordParameter);
        }
        return super.optionallyDecryptLdapPassword(ldapPasswordParameter);
    }

    @Override
    public RemoteDirectory getAuthorativeDirectory(DbCachingRemoteDirectory directoryInstance) {
        RemoteDirectory authoritativeDirectory = super.getAuthorativeDirectory(directoryInstance);
        try {
            Method getKeysMethod = authoritativeDirectory.getClass().getMethod("getKeys", new Class[0]);
            getKeysMethod.setAccessible(true);
            Method getValueMethod = authoritativeDirectory.getClass().getMethod("getValue", String.class);
            getValueMethod.setAccessible(true);
            HashMap<String, String> updatedAttributes = new HashMap<String, String>();
            for (String key : authoritativeDirectory.getKeys()) {
                String value = authoritativeDirectory.getValue(key);
                if ("ldap.password".equals(key)) {
                    value = this.optionallyDecryptLdapPassword(value);
                }
                updatedAttributes.put(key, value);
            }
            authoritativeDirectory.setAttributes(updatedAttributes);
        }
        catch (NoSuchMethodException e) {
            this.log.warn("Problem getting 'ldap.password' from RemoteDirectory");
        }
        catch (Exception e) {
            this.log.warn("Problem decrypting 'ldap.password' from RemoteDirectory");
        }
        return authoritativeDirectory;
    }

    private void publishBeforeUserAuthenticateEvent(Principal user, HttpSession session) {
        if (this.hasBeforeUserAuthenticateSupport()) {
            try {
                if (this.beforeUserAuthenticateClass != null) {
                    Constructor<?>[] cons = this.beforeUserAuthenticateClass.getConstructors();
                    Object o = cons[0].newInstance(user.getName());
                    this.eventPublisher.publish(o);
                } else {
                    this.log.warn("Could not load beforeUserAuthenticateClass");
                }
            }
            catch (Exception e) {
                this.log.warn("Unable to publish BeforeUserAuthenticate event during Jira login", (Throwable)e);
            }
        }
    }

    private void registerSuccessfulLoginInLoginStore(Principal user) {
        if (this.recordLoginMethod != null && this.loginComponent != null) {
            try {
                Object applicationUser = this.useApplicationUser && this.fromUser != null ? this.fromUser.invoke(null, user) : user;
                this.recordLoginMethod.invoke(this.loginComponent, applicationUser, true);
            }
            catch (Exception e) {
                this.log.warn("Failed invoking JIRA LoginStore.recordLoginAttempt with the following exception {}", (Object)e.getMessage());
            }
        }
    }

    @Override
    public String getStandardAuthenticatorClassName() {
        return "com.atlassian.jira.security.login.JiraSeraphAuthenticator";
    }

    @Override
    public String getLoginPage() {
        return "/login.jsp";
    }

    public static String getDashboardLoginPage() {
        return "/secure/Dashboard.jspa";
    }

    @Override
    public String getLogoutPage() {
        return "/secure/Logout!default.jspa";
    }

    @Override
    public boolean isLogoutPage(HttpServletRequest req) {
        String requestPath = HttpUrlUtils.getInternalPath(req);
        String requestPage = HttpUrlUtils.stripQueryStringFromInternalPath(requestPath).replaceAll("!default", "");
        return this.getLogoutPage().replaceAll("!default", "").equalsIgnoreCase(requestPage) || this.isServiceDeskLogout(req);
    }

    @Override
    public String getDefaultAdminGroupName() {
        if (this.getAllGroups().stream().anyMatch(group -> group.getName().equals("jira-administrators"))) {
            return "jira-administrators";
        }
        return null;
    }

    @Override
    public Map<String, String> mapNameToExternalId(List<User> userBatch, Map<String, String> userData) {
        userBatch.forEach(user -> userData.put(user.getName(), ((OfBizUser)user).getExternalId()));
        return userData;
    }

    @Override
    public String getLastLoginMillisFromUserWithAttributes(UserWithAttributes user) {
        return user.getValue("login.lastLoginMillis");
    }

    @Override
    public U jsmCleanup(InactiveUserCleaner<UserCleanupResultV1> inactiveUserCleaner, String currentUserName, RunAttributes runAttributes, CleanupRuleDTOV1 cleanupRule, DateTime inactivityCutoffTimestamp, SearchRestriction searchRestriction, String dryRunString, String runId) throws ConfigurationException, UnsupportedOperationException {
        this.inactiveUserCleaner.controlCleanupConfiguration(cleanupRule, runAttributes, false);
        Iterable<User> users = this.inactiveUserCleaner.searchUsersBasedOnRemoveGroup(false, null, searchRestriction, -1);
        List<String> directoryExclusionList = this.inactiveUserCleaner.getDirectoryExclusionList(cleanupRule);
        List<Long> cleanableDirectoryIds = this.inactiveUserCleaner.getCleanableDirectoryIds(cleanupRule, directoryExclusionList);
        List<ApplicationUser> userList = this.getApplicationUsers(this.inactiveUserCleaner, users, cleanupRule);
        ArrayList<UserSummary> affectedUsersList = new ArrayList<UserSummary>();
        List allDirectories = this.crowdDirectoryService.findAllDirectories();
        try {
            List<ApplicationUser> inactiveUsers = this.getUsersToJSMClean(currentUserName, cleanupRule.getDaysInactiveThreshold(), userList);
            for (ApplicationUser inactiveUser : inactiveUsers) {
                if (this.getJsmCleanupExecuteStatus() == CleanupStatus.NOT_RUN) {
                    throw new BreakException();
                }
                Directory inactiveUserDir = allDirectories.stream().filter(directory -> directory.getId().longValue() == inactiveUser.getDirectoryId()).findFirst().get();
                if (!this.inactiveUserCleaner.isUserEligibleForJSMCleanup(inactiveUser.getDirectoryId(), cleanableDirectoryIds, this.inactiveUserCleaner.getExcludedDirectoryIds(allDirectories, directoryExclusionList))) continue;
                this.inactiveUserCleaner.optionallyCleanupUser(dryRunString, runAttributes, cleanupRule, affectedUsersList, (User)this.getDirectoryManager().findUserByName(inactiveUserDir.getId().longValue(), inactiveUser.getName()), inactiveUserDir, cleanableDirectoryIds.contains(inactiveUser.getDirectoryId()));
            }
        }
        catch (DirectoryNotFoundException | OperationFailedException | UserNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (BreakException e) {
            this.log.warn("Jsm license cleanup: Cleanup process was cancelled mid run. " + affectedUsersList.size() + " users were affected before cancel. You can find complete list of affected users in the jsm cleanup log directory");
        }
        return (U)((UserCleanupResultV1)this.inactiveUserCleaner.createAndSaveUserCleanupResult(runAttributes, affectedUsersList, inactivityCutoffTimestamp, runId, cleanupRule, CleanupMode.JSM));
    }

    public List<ApplicationUser> getApplicationUsers(InactiveUserCleaner<U> inactiveUserCleaner, Iterable<User> users, CleanupRuleDTOV1 cleanupRule) {
        Set<String> whitelistedUserNames = inactiveUserCleaner.getWhitelistedUserNames(cleanupRule);
        ArrayList<ApplicationUser> userList = new ArrayList<ApplicationUser>();
        users.forEach(user -> {
            if (!whitelistedUserNames.contains(user.getName())) {
                userList.add(this.getApplicationUser(user.getName()));
            }
        });
        return userList;
    }

    public boolean hasBeforeUserAuthenticateSupport() {
        Version version = new Version(this.applicationProperties.getVersion());
        boolean isJiraVersion8 = (Boolean)version.getMajor().map(m -> m == 8).getOrElse((Object)false);
        boolean isJiraHigherThan8 = (Boolean)version.getMajor().map(m -> m > 8).getOrElse((Object)false);
        boolean isJiraMinor22OrHigher = (Boolean)version.getMinor().map(m -> m >= 22).getOrElse((Object)false);
        return isJiraHigherThan8 || isJiraVersion8 && isJiraMinor22OrHigher;
    }

    @Override
    public UnifiedLicenseInfo getLicenseSize() {
        UnifiedLicenseInfo unifiedLicenseInfo = new UnifiedLicenseInfo();
        int totalBillableUsers = this.licenseCountService.totalBillableUsers();
        unifiedLicenseInfo.setTotalBillableUsers(totalBillableUsers);
        Collection results = this.licenseHandler.getAllProductLicenses();
        int maximumNumberOfUsers = 0;
        for (MultiProductLicenseDetails details : results) {
            Set productLicenses = details.getProductLicenses();
            for (ProductLicense license : productLicenses) {
                if (!license.isUnlimitedNumberOfUsers()) {
                    maximumNumberOfUsers = license.getNumberOfUsers();
                    continue;
                }
                maximumNumberOfUsers = -1;
            }
        }
        unifiedLicenseInfo.setMaximumNumberOfUsers(maximumNumberOfUsers);
        return unifiedLicenseInfo;
    }

    public boolean hasJiraSoftwareAccess(Principal user) {
        ApplicationUser applicationUser = this.toApplicationUser(user);
        if (applicationUser == null) {
            return false;
        }
        ApplicationKey jiraSoftwareKey = ApplicationKey.valueOf((String)"jira-software");
        return this.applicationRoleManager.userHasRole(applicationUser, jiraSoftwareKey);
    }

    public boolean hasJiraServiceDeskAccess(Principal user) {
        ApplicationUser applicationUser = this.toApplicationUser(user);
        if (applicationUser == null) {
            return false;
        }
        ApplicationKey jiraServiceDeskKey = ApplicationKey.valueOf((String)"jira-servicedesk");
        return this.applicationRoleManager.userHasRole(applicationUser, jiraServiceDeskKey);
    }

    private ApplicationUser toApplicationUser(Principal user) {
        return user != null ? this.getUserManager().getUserByName(user.getName()) : null;
    }

    @Override
    public Set<String> getUserApplicationRoles(Principal user) {
        ApplicationUser applicationUser = this.toApplicationUser(user);
        return this.applicationRoleManager.getOccupiedLicenseRolesForUser(applicationUser).stream().map(ApplicationRole::getName).collect(Collectors.toSet());
    }

    @Override
    public boolean isJSMUser(String username) {
        ApplicationUser user = this.userManager.getUserByName(username);
        if (user == null) {
            return false;
        }
        ApplicationAuthorizationService authService = (ApplicationAuthorizationService)ComponentAccessor.getComponent(ApplicationAuthorizationService.class);
        return authService.canUseApplication(user, ApplicationKeys.SERVICE_DESK);
    }

    @Override
    public Set<Group> getJSMGroups() {
        ApplicationRoleManager applicationRoleManager = (ApplicationRoleManager)ComponentAccessor.getComponent(ApplicationRoleManager.class);
        for (ApplicationRole role : applicationRoleManager.getRoles()) {
            if (ApplicationKeys.SERVICE_DESK != role.getKey()) continue;
            Set groups = role.getGroups();
            return groups;
        }
        return new HashSet<Group>();
    }

    public List<ApplicationUser> getUsersToJSMClean(String currentUsername, int updatedDaysSince, List<ApplicationUser> unfilteredUsers) {
        return this.getUsersToJSMClean(currentUsername, updatedDaysSince, unfilteredUsers, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ApplicationUser> getUsersToJSMClean(String currentUsername, int updatedDaysSince, List<ApplicationUser> unfilteredUsers, boolean filterForJsmRoles) {
        List<Object> usersInactiveInJsm;
        block18: {
            HashMap<String, ApplicationUser> activeUsers;
            block17: {
                String key;
                List issues;
                ApplicationUser currentUser = this.userManager.getUserByName(currentUsername);
                SearchService searchService = (SearchService)ComponentAccessor.getComponent(SearchService.class);
                JqlQueryParser jqlQueryParser = (JqlQueryParser)ComponentAccessor.getComponent(JqlQueryParser.class);
                ChangeHistoryManager changeHistoryManager = ComponentAccessor.getChangeHistoryManager();
                CommentManager commentManager = ComponentAccessor.getCommentManager();
                UserManager userManager = ComponentAccessor.getUserManager();
                String issuesJqlQuery = String.format("updated >= -%dd", updatedDaysSince);
                Calendar searchAfterCalendar = Calendar.getInstance();
                searchAfterCalendar.add(5, -updatedDaysSince);
                Date searchAfterDate = searchAfterCalendar.getTime();
                JiraThreadLocalUtils.preCall();
                try {
                    try {
                        issues = searchService.search(currentUser, jqlQueryParser.parseQuery(issuesJqlQuery), PagerFilter.getUnlimitedFilter()).getResults();
                    }
                    catch (SearchException | JqlParseException e) {
                        throw new RuntimeException("Problem in getUsersToJSMClean", e);
                    }
                }
                finally {
                    JiraThreadLocalUtils.postCall();
                }
                if (issues == null) {
                    return null;
                }
                issues = issues.stream().filter(issue -> issue.getProjectObject() != null && issue.getProjectObject().getProjectTypeKey().getKey().equals("service_desk")).collect(Collectors.toList());
                ArrayList comments = new ArrayList();
                for (Object i : issues) {
                    comments.addAll(commentManager.getCommentsForUserSince((Issue)i, currentUser, searchAfterDate));
                }
                ArrayList issueChanges = new ArrayList();
                for (Object i : issues) {
                    issueChanges.addAll(changeHistoryManager.getChangeHistoriesSince((Issue)i, searchAfterDate));
                }
                activeUsers = new HashMap<String, ApplicationUser>();
                for (Comment c : comments) {
                    key = c.getAuthorApplicationUser().getKey();
                    activeUsers.put(key, userManager.getUserByKey(key));
                }
                for (Comment c : issueChanges) {
                    key = c.getAuthorKey();
                    activeUsers.put(key, userManager.getUserByKey(key));
                }
                Set<Object> jsmGroups = new HashSet();
                if (filterForJsmRoles) {
                    jsmGroups = this.getJSMGroups();
                }
                usersInactiveInJsm = new ArrayList<ApplicationUser>();
                if (!filterForJsmRoles) break block17;
                GroupManager groupManager = ComponentAccessor.getGroupManager();
                HashMap jsmUserMap = new HashMap();
                for (Group group : jsmGroups) {
                    Collection jsmAppUsers = groupManager.getUsersInGroup(group);
                    jsmAppUsers.forEach(user -> jsmUserMap.put(user.getKey(), user));
                }
                if (unfilteredUsers != null) {
                    for (ApplicationUser applicationUser : unfilteredUsers) {
                        if (!jsmUserMap.containsKey(applicationUser.getKey()) || activeUsers.containsKey(applicationUser.getKey())) continue;
                        usersInactiveInJsm.add(applicationUser);
                    }
                } else {
                    usersInactiveInJsm = jsmUserMap.values().stream().filter(u -> !activeUsers.containsKey(u.getKey())).collect(Collectors.toList());
                }
                break block18;
            }
            if (unfilteredUsers == null) break block18;
            for (ApplicationUser user3 : unfilteredUsers) {
                if (activeUsers.containsKey(user3.getKey())) continue;
                usersInactiveInJsm.add(user3);
            }
        }
        return usersInactiveInJsm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<User> getUsersToJSMCleanNoRoles(String currentUsername, int updatedDaysSince, Iterable<User> unfilteredUsers, CleanupMode jsmCleanupMode) {
        ApplicationUser currentUser = this.userManager.getUserByName(currentUsername);
        SearchService searchService = (SearchService)ComponentAccessor.getComponent(SearchService.class);
        JqlQueryParser jqlQueryParser = (JqlQueryParser)ComponentAccessor.getComponent(JqlQueryParser.class);
        ChangeHistoryManager changeHistoryManager = ComponentAccessor.getChangeHistoryManager();
        CommentManager commentManager = ComponentAccessor.getCommentManager();
        ArrayList<String> userNamesWindow = new ArrayList<String>();
        HashSet<String> activeUserKeys = new HashSet<String>();
        Iterator<User> iterator = unfilteredUsers.iterator();
        int PROCESS_JQL_REPORTER_BATCH_SIZE = 10;
        while (iterator.hasNext()) {
            List issues;
            userNamesWindow.clear();
            for (int i = 0; i < PROCESS_JQL_REPORTER_BATCH_SIZE && iterator.hasNext(); ++i) {
                User user = iterator.next();
                userNamesWindow.add(user.getName());
            }
            if (userNamesWindow.isEmpty()) continue;
            String jqlUserClause = userNamesWindow.stream().map(name -> "\"" + name + "\"").collect(Collectors.joining(","));
            String requestChannelFilter = "";
            switch (jsmCleanupMode) {
                case JSMEMAIL: {
                    requestChannelFilter = "AND request-channel-type = email";
                    break;
                }
                default: {
                    requestChannelFilter = "AND request-channel-type in (email,portal)";
                }
            }
            String issuesJqlQuery = String.format("updated >= -%dd " + requestChannelFilter + " AND reporter was in (%s)", updatedDaysSince, jqlUserClause);
            Calendar searchAfterCalendar = Calendar.getInstance();
            searchAfterCalendar.add(5, -updatedDaysSince);
            Date searchAfterDate = searchAfterCalendar.getTime();
            JiraThreadLocalUtils.preCall();
            try {
                try {
                    issues = searchService.search(currentUser, jqlQueryParser.parseQuery(issuesJqlQuery), PagerFilter.getUnlimitedFilter()).getResults();
                }
                catch (SearchException | JqlParseException e) {
                    throw new RuntimeException("Problem in getUsersToJSMClean", e);
                }
            }
            finally {
                JiraThreadLocalUtils.postCall();
            }
            if (issues == null) {
                return unfilteredUsers;
            }
            for (Issue i : issues) {
                for (Comment c : commentManager.getCommentsForUserSince(i, currentUser, searchAfterDate)) {
                    activeUserKeys.add(c.getAuthorApplicationUser().getKey());
                }
            }
            for (Issue i : issues) {
                for (Comment c : changeHistoryManager.getChangeHistoriesSince(i, searchAfterDate)) {
                    activeUserKeys.add(c.getAuthorKey());
                }
            }
        }
        ArrayList<User> inactiveUsers = new ArrayList<User>();
        for (User user : unfilteredUsers) {
            if (activeUserKeys.contains(user.getName())) continue;
            inactiveUsers.add(user);
        }
        return inactiveUsers;
    }

    public ApplicationUser getApplicationUser(String username) {
        return this.userManager.getUserByName(username);
    }

    public static class CanUseStatus {
        private final ApplicationUser user;
        private boolean hasGlobalAdminPermission;
        private boolean hasAnyRole;

        public CanUseStatus(String username) {
            this.user = this.createApplicationUser(username);
        }

        private ApplicationUser createApplicationUser(final String userName) {
            return new ApplicationUser(){

                public String getKey() {
                    return userName;
                }

                public String getUsername() {
                    return userName;
                }

                public String getName() {
                    return userName;
                }

                public long getDirectoryId() {
                    return 0L;
                }

                public boolean isActive() {
                    return true;
                }

                public String getEmailAddress() {
                    return null;
                }

                public String getDisplayName() {
                    return null;
                }

                public User getDirectoryUser() {
                    return null;
                }

                public Long getId() {
                    return null;
                }
            };
        }

        public boolean hasGlobalAdminPermission() {
            return this.hasGlobalAdminPermission;
        }

        public boolean hasAnyRole() {
            return this.hasAnyRole;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CanUseStatus invoke() {
            Thread ct = Thread.currentThread();
            ClassLoader oldCcl = ct.getContextClassLoader();
            try {
                GlobalPermissionManager globalPermissionManager = (GlobalPermissionManager)ComponentLocator.getComponent(GlobalPermissionManager.class);
                ct.setContextClassLoader(GlobalPermissionManager.class.getClassLoader());
                this.hasGlobalAdminPermission = globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, this.user);
                ApplicationRoleManager applicationRoleManager = (ApplicationRoleManager)ComponentLocator.getComponent(ApplicationRoleManager.class);
                this.hasAnyRole = applicationRoleManager.hasAnyRole(this.user);
            }
            finally {
                ct.setContextClassLoader(oldCcl);
            }
            return this;
        }
    }
}

