/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.hostapp;

import com.atlassian.crowd.directory.DbCachingRemoteDirectory;
import com.atlassian.crowd.directory.RemoteCrowdDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.loader.DbCachingRemoteDirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.user.User;
import org.kantega.atlaskerb.hostapp.CommonHostApp;
import org.kantega.atlaskerb.hostapp.RemoteUserUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRemoteUserUpdater
implements RemoteUserUpdater {
    private static final Logger log = LoggerFactory.getLogger(DefaultRemoteUserUpdater.class);
    final DbCachingRemoteDirectoryInstanceLoader instanceLoader;

    public DefaultRemoteUserUpdater(DbCachingRemoteDirectoryInstanceLoader directoryInstanceLoader) {
        this.instanceLoader = directoryInstanceLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void updateUser(String username, Directory directory, CommonHostApp hostApp) throws OperationFailedException, UserNotFoundException, InactiveAccountException {
        Thread ct = Thread.currentThread();
        ClassLoader oldCcl = ct.getContextClassLoader();
        try {
            ct.setContextClassLoader(CrowdService.class.getClassLoader());
            this.doUpdateUser(username, directory, hostApp);
        }
        finally {
            ct.setContextClassLoader(oldCcl);
        }
    }

    void doUpdateUser(String username, Directory directory, CommonHostApp hostApp) throws OperationFailedException, UserNotFoundException, InactiveAccountException {
        User remoteUser;
        DbCachingRemoteDirectory directoryInstance;
        block6: {
            directoryInstance = (DbCachingRemoteDirectory)this.instanceLoader.getDirectory(directory);
            RemoteDirectory authoritativeDirectory = hostApp.getAuthorativeDirectory(directoryInstance);
            remoteUser = null;
            if (directory.getType() == DirectoryType.CROWD) {
                try {
                    log.debug("Calling userAuthenticated() for {} in Crowd directory {}", (Object)username, (Object)directory.getName());
                    RemoteCrowdDirectory remoteCrowdDirectory = (RemoteCrowdDirectory)authoritativeDirectory;
                    remoteUser = remoteCrowdDirectory.userAuthenticated(username);
                }
                catch (OperationFailedException e) {
                    if (log.isDebugEnabled()) {
                        log.warn("Could not authenticate '{}' in '{}'. Not updating account.", new Object[]{username, directory.getName(), e});
                        break block6;
                    }
                    log.warn("Could not authenticate '{}' in '{}'. Not updating account: {}", new Object[]{username, ": " + e.getMessage(), directory.getName()});
                }
            } else {
                remoteUser = authoritativeDirectory.findUserByName(username);
            }
        }
        if (remoteUser != null) {
            directoryInstance.updateUserFromRemoteDirectory(remoteUser);
        }
    }
}

