#!/bin/bash
echo Running for Macos or Linux the file pluginkey-prepare-prodsplit.sh
defaultAppKey=no.kantega.kerberosauth.kerberosauth-plugin
echo ProductKey: $1
echo ProductName: $2
echo ProductDisplayName: $3
echo ProductDescription: $4

productDescription=$4
echo  ProductDescription: $productDescription

if [[ 'cea4b4d2-9e2c-4c93-bfa5-0b944b0876d0' != $1 ]]; then
  if [[ $(uname) == "Darwin" ]]; then
    echo replacing to $1 in .bundle.js and other files to prepare for $3
    sed -i '' "s/$defaultAppKey/$1/g" target/classes/*.bundle.js
    sed -i '' "s/$defaultAppKey/$1/g" target/classes/templates/atlaskerb/injectDirectoryActions.vm
    sed -i '' "s/$defaultAppKey/$1/g" target/classes/META-INF/plugin-descriptors/wr-webpack-bundles.xml
    sed -i '' "s/$defaultAppKey/$1/g" target/classes/META-INF/MANIFEST.MF
    sed -i '' "s/no.kantega.kerberosauth.plugin/$1/g" target/classes/META-INF/MANIFEST.MF
  
    #echo replacing to $2 for rest services /ksso/api and /ksso/internal in atlassian-plugin.xml
    sed -i '' "s/path=\"\/ksso\/api/path=\"\/${2}\/api/g" target/classes/atlassian-plugin.xml
    sed -i '' "s/path=\"\/ksso\/internal/path=\"\/${2}\/internal/g" target/classes/atlassian-plugin.xml
  
    sed -i '' "s/location=\"atlaskerb\"/location=\"${2}\"/g" target/classes/atlassian-plugin.xml
  
    find target/classes -type f \( -name "*.properties" -o -name "*.vm" -o -name "*.xml" \) -exec sed -i '' "s/atlaskerb.link./$2.link./g" {} +
    find target/classes -type f \( -name "*.properties" -o -name "*.vm" -o -name "*.xml" \) -exec sed -i '' "s/atlaskerb.config./$2.config./g" {} +
    find target/classes -type f \( -name "*.properties" -o -name "*.vm" -o -name "*.xml" \) -exec sed -i '' "s/atlaskerb.test./$2.test./g" {} +
    find target/classes -type f \( -name "*.properties" -o -name "*.vm" -o -name "*.xml" \) -exec sed -i ''   "s/atlaskerb.keytab./$2.keytab./g" {} +
    find target/classes -type f \( -name "*.vm" \) -exec sed -i '' "s/Kantega SSO/$3/g" {} +
    find target/classes -type f \( -name "*.vm" \) -exec sed -i '' "s/Kantega SSO Enterprise/$3/g" {} +
  
    # introduce productDescription in atlassian-plugin.xml
    awk -v productDescription="$productDescription" -v RS='</description><version>' -v ORS='' '{gsub(/<plugin-info><description>.*$/, "<plugin-info><description>" productDescription "</description><version>"); print $0 RT}' target/classes/atlassian-plugin.xml > temp-.xml && mv temp-.xml target/classes/atlassian-plugin.xml
  
    sed -i '' "s/Kantega SSO Enterprise/$3/g" target/classes/atlassian-plugin.xml
    sed -i '' "s/Kantega SSO Enterprise/$3/g" target/classes/atlaskerb.properties
    sed -i '' "s/atlaskerb\./$2\./g" target/classes/atlaskerb.properties
    mv target/classes/atlaskerb.properties target/classes/$2.properties
  
    echo replacing to $2 for all files calling rest services /ksso/api and /ksso/internal
    find target/classes -type f \( -name "*.js" -o -name "*.vm" \) -exec sed -i '' "s/\/rest\/ksso\/internal/\/rest\/$2\/internal/g" {} +
    find target/classes -type f \( -name "*.js" -o -name "*.vm" \) -exec sed -i '' "s/\/rest\/ksso\/api/\/rest\/$2\/api/g" {} +
  else # Linux does not use sed -i ''  and putting '' in variable did not work
       sed -i "s/$defaultAppKey/$1/g" target/classes/*.bundle.js
       sed -i "s/$defaultAppKey/$1/g" target/classes/templates/atlaskerb/injectDirectoryActions.vm
       sed -i "s/$defaultAppKey/$1/g" target/classes/META-INF/plugin-descriptors/wr-webpack-bundles.xml
       sed -i "s/$defaultAppKey/$1/g" target/classes/META-INF/MANIFEST.MF
       sed -i "s/no.kantega.kerberosauth.plugin/$1/g" target/classes/META-INF/MANIFEST.MF

       #echo replacing to $2 for rest services /ksso/api and /ksso/internal in atlassian-plugin.xml
       sed -i "s/path=\"\/ksso\/api/path=\"\/${2}\/api/g" target/classes/atlassian-plugin.xml
       sed -i "s/path=\"\/ksso\/internal/path=\"\/${2}\/internal/g" target/classes/atlassian-plugin.xml

       sed -i "s/location=\"atlaskerb\"/location=\"${2}\"/g" target/classes/atlassian-plugin.xml

       find target/classes -type f \( -name "*.properties" -o -name "*.vm" -o -name "*.xml" \) -exec sed -i "s/atlaskerb.link./$2.link./g" {} +
       find target/classes -type f \( -name "*.properties" -o -name "*.vm" -o -name "*.xml" \) -exec sed -i "s/atlaskerb.config./$2.config./g" {} +
       find target/classes -type f \( -name "*.properties" -o -name "*.vm" -o -name "*.xml" \) -exec sed -i "s/atlaskerb.test./$2.test./g" {} +
       find target/classes -type f \( -name "*.properties" -o -name "*.vm" -o -name "*.xml" \) -exec sed -i "s/atlaskerb.keytab./$2.keytab./g" {} +
       find target/classes -type f \( -name "*.vm" \) -exec sed -i "s/Kantega SSO/$3/g" {} +
       find target/classes -type f \( -name "*.vm" \) -exec sed -i "s/Kantega SSO Enterprise/$3/g" {} +

       # introduce productDescription in atlassian-plugin.xml
       awk -v productDescription="$productDescription" -v RS='</description><version>' -v ORS='' '{gsub(/<plugin-info><description>.*$/, "<plugin-info><description>" productDescription "</description><version>"); print $0 RT}' target/classes/atlassian-plugin.xml > temp-.xml && mv temp-.xml target/classes/atlassian-plugin.xml

       sed -i "s/Kantega SSO Enterprise/$3/g" target/classes/atlassian-plugin.xml
       sed -i "s/Kantega SSO Enterprise/$3/g" target/classes/atlaskerb.properties
       sed -i "s/atlaskerb\./$2\./g" target/classes/atlaskerb.properties
       mv target/classes/atlaskerb.properties target/classes/$2.properties

       echo replacing to $2 for all files calling rest services /ksso/api and /ksso/internal
       find target/classes -type f \( -name "*.js" -o -name "*.vm" \) -exec sed -i "s/\/rest\/ksso\/internal/\/rest\/$2\/internal/g" {} +
       find target/classes -type f \( -name "*.js" -o -name "*.vm" \) -exec sed -i "s/\/rest\/ksso\/api/\/rest\/$2\/api/g" {} +
  fi
fi