/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.utils;

import javax.servlet.http.HttpServletRequest;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ContextAware {
    private final HttpServletRequest request;

    public ContextAware(@NonNull HttpServletRequest request) {
        this.request = request;
    }

    public static ContextAware of(@NonNull HttpServletRequest request) {
        return new ContextAware(request);
    }

    public String path(String path) {
        return this.request.getContextPath() + path;
    }

    public String getUriWithContextPath() {
        return this.request.getRequestURI();
    }

    public String getUriWithoutContextPath() {
        return this.request.getRequestURI().substring(this.request.getContextPath().length());
    }
}

