/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.usercleanup.v2;

import com.atlassian.annotations.PublicApi;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Try;
import java.io.Serializable;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.kantega.atlaskerb.hostapp.CleanupHostApp;
import org.kantega.atlaskerb.hostapp.CleanupHostAppFactoryV2;
import org.kantega.atlaskerb.hostapp.DefaultCleanupHostApp;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.UserSummary;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v2.jsoncreatorclasses.CleanupLogAttributesV2;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v2.jsoncreatorclasses.UserCleanupResultV2;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v2.jsoncreatorclasses.UserSummaryV2;
import org.kantega.atlaskerb.rest.util.ResponseUtils;
import org.kantega.atlaskerb.usercleanup.v2.InactiveUserCleanerV2;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="cleanup-logs")
@PublicApi
public class GetCleanupLogsV2 {
    private static final Logger log = LoggerFactory.getLogger(GetCleanupLogsV2.class);
    private final UserManager userManager;
    private CleanupHostApp<UserCleanupResultV2> hostApp;
    private final JsonWrapper jsonWrapper;
    private InactiveUserCleanerV2 inactiveUserCleanerV2;
    CleanupHostAppFactoryV2 cleanupHostAppFactoryV2;

    @Autowired
    @Inject
    public GetCleanupLogsV2(@ComponentImport UserManager userManager, JsonWrapper jsonWrapper, InactiveUserCleanerV2 inactiveUserCleanerV2) {
        this.userManager = userManager;
        this.jsonWrapper = jsonWrapper;
        log.info("GetCleanupLogsV2 constructor");
        this.inactiveUserCleanerV2 = inactiveUserCleanerV2;
        if (this.inactiveUserCleanerV2 != null) {
            this.hostApp = inactiveUserCleanerV2.getHostApp();
        }
    }

    @Autowired
    public void setInactiveUserCleaner(InactiveUserCleanerV2 inactiveUserCleaner) {
        log.info("GetCleanupLogsV2 setInactiveUserCleaner");
        if (this.inactiveUserCleanerV2 == null) {
            this.inactiveUserCleanerV2 = inactiveUserCleaner;
            if (this.inactiveUserCleanerV2 != null) {
                this.hostApp = this.inactiveUserCleanerV2.getHostApp();
            }
        }
    }

    private Response run(UserProfile userProfile, UserManager userManager, CleanupLogAttributesV2 cleanupLogAttributes, HttpServletRequest req) {
        if (!userManager.isSystemAdmin(userProfile.getUserKey())) {
            return ResponseUtils.errorWithMessageInJson(Response.Status.FORBIDDEN, "Missing access privileges");
        }
        log.info("GetCleanupLogsV2 this.inactiveUserCleanerV2.getCleanupLog");
        UserCleanupResultV2[] cleanupLog = this.inactiveUserCleanerV2.getCleanupLog(cleanupLogAttributes);
        if (cleanupLogAttributes.isIncludeUsers()) {
            for (UserCleanupResultV2 res : cleanupLog) {
                for (UserSummary summary : res.getAffectedUsers()) {
                    User userWithAttributes = this.hostApp.getCrowdService().getUser(summary.getUsername());
                    if (userWithAttributes == null) continue;
                    Principal principal = () -> {
                        if (userWithAttributes == null) {
                            return "";
                        }
                        return userWithAttributes.getName();
                    };
                    summary.setIsLicensedGroupMember(this.hostApp.canLogin(principal, req));
                    summary.setIsActive(userWithAttributes.isActive());
                    summary.setInGroup(false);
                }
            }
        }
        return (Response)this.jsonWrapper.tryBuildJsonString(cleanupLog).map(jsonString -> Response.ok((Object)jsonString, (MediaType)MediaType.APPLICATION_JSON_TYPE).build()).onFailure(throwable -> log.error("Failed to build JSON: ", throwable)).getOrElse((Object)Response.serverError().build());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response doPost(@Context HttpServletRequest request, CleanupLogAttributesV2 cleanupLogAttributes) {
        return ResponseUtils.user(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)userProfile -> (Response)Try.of((CheckedFunction0 & Serializable)() -> this.run((UserProfile)userProfile, this.userManager, cleanupLogAttributes, request)).onFailure(e -> log.error("Encountered an exception while atempting to GET cleanup rule. ", e)).getOrElse((Object)Response.serverError().build()));
    }

    @GET
    @Produces(value={"application/json"})
    public Response doGet(@Context HttpServletRequest request, @QueryParam(value="nofRunsToFetch") @DefaultValue(value="10") int nofRunsToFetch, @QueryParam(value="dryRun") @DefaultValue(value="false") boolean dryRun, @QueryParam(value="simulateCronDate") @DefaultValue(value="false") boolean simulateCronDate, @QueryParam(value="includeAllLogs") @DefaultValue(value="true") boolean includeAllLogs, @QueryParam(value="jsmCleanup") @DefaultValue(value="false") boolean jsmCleanup, @QueryParam(value="includeUsers") @DefaultValue(value="false") Boolean includeUsers) {
        if (includeUsers == null) {
            includeUsers = false;
        }
        CleanupLogAttributesV2 cleanupLogAttributes = new CleanupLogAttributesV2(nofRunsToFetch, dryRun, simulateCronDate, includeAllLogs, jsmCleanup, includeUsers);
        return ResponseUtils.user(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)userProfile -> (Response)Try.of((CheckedFunction0 & Serializable)() -> this.run((UserProfile)userProfile, this.userManager, cleanupLogAttributes, request)).onFailure(e -> log.error("Encountered an exception while attempting to GET cleanup rule. ", e)).getOrElse((Object)Response.serverError().build()));
    }

    @GET
    @Path(value="{filenameId}")
    @Produces(value={"application/json"})
    public Response doGetSingleLog(@Context HttpServletRequest request, @PathParam(value="filenameId") String filenameId) {
        return ResponseUtils.user(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)userProfile -> {
            if (!this.userManager.isSystemAdmin(userProfile.getUserKey())) {
                return ResponseUtils.errorWithMessageInJson(Response.Status.FORBIDDEN, "Missing access privileges");
            }
            UserCleanupResultV2 cleanupLog = this.inactiveUserCleanerV2.getCleanupLogByFilenameId(filenameId);
            if (cleanupLog == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            HashMap groupToUserNamesMap = new HashMap();
            if (cleanupLog.getGroupsToRemove() != null) {
                for (String group : cleanupLog.getGroupsToRemove()) {
                    Iterable<User> usersInGroup = this.inactiveUserCleanerV2.searchUsersBasedOnEligibleGroupNames(true, new String[]{group}, (SearchRestriction)NullRestrictionImpl.INSTANCE, -1);
                    HashSet<String> userNames = new HashSet<String>();
                    for (User user : usersInGroup) {
                        userNames.add(user.getName());
                    }
                    groupToUserNamesMap.put(group, userNames);
                }
            } else {
                cleanupLog.setGroupsToRemove(new String[0]);
            }
            if (cleanupLog.getAffectedUsersV2() != null) {
                for (UserSummaryV2 summary : cleanupLog.getAffectedUsersV2()) {
                    User userWithAttributes = this.hostApp.getCrowdService().getUser(summary.getUsername());
                    if (userWithAttributes == null) continue;
                    Principal principal = () -> {
                        if (userWithAttributes == null) {
                            return "";
                        }
                        return userWithAttributes.getName();
                    };
                    if (this.hostApp instanceof DefaultCleanupHostApp) {
                        Set<String> userApplicationRoles = ((DefaultCleanupHostApp)this.hostApp).getUserApplicationRoles((Principal)userWithAttributes);
                        HashSet<String> userApplicationRolesMaped = new HashSet<String>();
                        for (String userApplicationRole : userApplicationRoles) {
                            userApplicationRolesMaped.add(userApplicationRole);
                        }
                        summary.setRoles(userApplicationRolesMaped);
                    }
                    if (cleanupLog.getGroupsToRemove() != null && cleanupLog.getGroupsToRemove().length > 0) {
                        boolean isInGroup = false;
                        HashSet<String> notRemovedFromGroups = new HashSet<String>();
                        HashSet<String> removedFromGroups = new HashSet<String>();
                        for (String group : cleanupLog.getGroupsToRemove()) {
                            Set userNamesInGroup = (Set)groupToUserNamesMap.get(group);
                            if (userNamesInGroup != null && userNamesInGroup.contains(userWithAttributes.getName())) {
                                isInGroup = true;
                                notRemovedFromGroups.add(group);
                                continue;
                            }
                            removedFromGroups.add(group);
                        }
                        summary.setInGroup(isInGroup);
                        summary.setNotRemovedFromGroups(notRemovedFromGroups.toArray(new String[0]));
                        summary.setRemovedFromGroups(removedFromGroups.toArray(new String[0]));
                    } else {
                        summary.setInGroup(false);
                    }
                    summary.setIsActive(userWithAttributes.isActive());
                }
            } else {
                cleanupLog.setAffectedUsersV2(new UserSummaryV2[0]);
            }
            return (Response)this.jsonWrapper.tryBuildJsonString(cleanupLog).map(jsonString -> Response.ok((Object)jsonString, (MediaType)MediaType.APPLICATION_JSON_TYPE).build()).onFailure(throwable -> log.error("Failed to build JSON: ", throwable)).getOrElse((Object)Response.serverError().build());
        });
    }
}

