/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.usercleanup.v2;

import com.atlassian.annotations.PublicApi;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.kantega.atlaskerb.hostapp.CleanupHostApp;
import org.kantega.atlaskerb.hostapp.CleanupHostAppFactoryV2;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v2.jsoncreatorclasses.ExecuteSingleUserAttributesV2;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v2.jsoncreatorclasses.UserCleanupResultV2;
import org.kantega.atlaskerb.rest.util.ResponseUtils;
import org.kantega.atlaskerb.usercleanup.v2.InactiveUserCleanerV2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="execute-single-user")
@PublicApi
public class ExecuteSingleUserV2 {
    private static final Logger log = LoggerFactory.getLogger(ExecuteSingleUserV2.class);
    private final UserManager userManager;
    private final CleanupHostApp<UserCleanupResultV2> hostApp;
    private InactiveUserCleanerV2 inactiveUserCleanerV2;

    @Autowired
    @Inject
    public void setInactiveUserCleaner(InactiveUserCleanerV2 inactiveUserCleaner) {
        this.inactiveUserCleanerV2 = inactiveUserCleaner;
    }

    @Autowired
    @Inject
    public ExecuteSingleUserV2(@ComponentImport UserManager userManager, CleanupHostAppFactoryV2 hostAppFactory, InactiveUserCleanerV2 inactiveUserCleaner) {
        this.userManager = userManager;
        this.hostApp = hostAppFactory.getInstance();
        this.inactiveUserCleanerV2 = inactiveUserCleaner;
    }

    private Response activateUser(Directory userDirectory, User user) {
        try {
            this.hostApp.updateUser(userDirectory, user.getName(), user.getDisplayName(), user.getEmailAddress(), true);
            return Response.ok().build();
        }
        catch (Exception e) {
            return ResponseUtils.errorWithMessageInJson(Response.Status.BAD_REQUEST, "Failed to activate user");
        }
    }

    private Response deactivateUser(Directory userDirectory, User user) {
        if (!this.hostApp.getInactiveUserCleaner().deactivateUser(userDirectory, user)) {
            return ResponseUtils.errorWithMessageInJson(Response.Status.BAD_REQUEST, "Failed to deactivate user");
        }
        return Response.ok().build();
    }

    private Directory getUserDirectory(User user) {
        Optional<Directory> dirStream = this.hostApp.getCrowdDirectoryService().findAllDirectories().stream().filter(directory -> directory.getId().longValue() == user.getDirectoryId()).findFirst();
        return dirStream.orElse(null);
    }

    private Response run(UserProfile userProfile, UserManager userManager, ExecuteSingleUserAttributesV2 executeSingleUserAttributes) {
        if (!userManager.isSystemAdmin(userProfile.getUserKey())) {
            return ResponseUtils.errorWithMessageInJson(Response.Status.FORBIDDEN, "Missing access privileges");
        }
        this.hostApp.verifyLicense();
        User user = this.hostApp.getCrowdService().getUser(executeSingleUserAttributes.getUser());
        List<String> groups = executeSingleUserAttributes.getGroups();
        String action = executeSingleUserAttributes.getAction();
        if (user == null) {
            return ResponseUtils.errorWithMessageInJson(Response.Status.BAD_REQUEST, "Unspecified user");
        }
        try {
            if ("activate".equalsIgnoreCase(action) || "deactivate".equalsIgnoreCase(action)) {
                this.inactiveUserCleanerV2.activateOrDeactivateUser(user, action);
            } else {
                this.inactiveUserCleanerV2.manageUserGroups(user, groups, action);
            }
        }
        catch (Exception e) {
            return ResponseUtils.errorWithMessageInJson(Response.Status.BAD_REQUEST, e.getMessage());
        }
        return Response.ok().build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response doPost(@Context HttpServletRequest request, ExecuteSingleUserAttributesV2 executeSingleUserAttributes) {
        return ResponseUtils.user(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)userProfile -> (Response)Try.of((CheckedFunction0 & Serializable)() -> this.run((UserProfile)userProfile, this.userManager, executeSingleUserAttributes)).onFailure(e -> log.error("Encountered an exception while attempting to cleanup user. ", e)).getOrElse((Object)Response.serverError().build()));
    }
}

