/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.jobs;

import com.atlassian.config.ConfigurationException;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobRunnerKey;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.kantega.atlaskerb.hostapp.CleanupHostApp;
import org.kantega.atlaskerb.hostapp.CleanupHostAppFactoryV1;
import org.kantega.atlaskerb.hostapp.JiraCleanupHostApp;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.RunAttributes;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.UserCleanupResultV1;
import org.kantega.atlaskerb.usercleanup.CleanupStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JsmCleanupJobRunner
implements JobRunner {
    public static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)(JsmCleanupJobRunner.class + ".job"));
    private static final Logger log = LoggerFactory.getLogger(JsmCleanupJobRunner.class);
    private final CleanupHostApp<UserCleanupResultV1> hostApp;

    @Inject
    public JsmCleanupJobRunner(CleanupHostAppFactoryV1 hostAppFactory) {
        this.hostApp = hostAppFactory.getInstance();
    }

    public JsmCleanupJobRunner(JiraCleanupHostApp<UserCleanupResultV1> hostApp) {
        this.hostApp = hostApp;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        try {
            log.info(String.format("JsmCleanup: Starting scheduled run, previous CleanupStatus is %s", this.hostApp.getJsmCleanupExecuteStatus().toString()));
            if (this.hostApp.getJsmCleanupExecuteStatus() == CleanupStatus.RUNNING) {
                log.warn(String.format("JsmCleanup: Scheduled run did not start since a cleanup is already running, CleanupStatus is %s", this.hostApp.getJsmCleanupExecuteStatus().toString()));
                return JobRunnerResponse.aborted((String)"Cleanup already running");
            }
            this.hostApp.setJsmCleanupExecuteStatus(CleanupStatus.RUNNING);
            this.hostApp.cleanupInactiveUsers(null, new RunAttributes(false, false, true), DateTime.now(), UUID.randomUUID().toString());
        }
        catch (ConfigurationException e) {
            this.hostApp.setJsmCleanupExecuteStatus(CleanupStatus.FAILED);
            log.error(String.format("JsmCleanup: Scheduled run failed, current CleanupStatus is %s", this.hostApp.getJsmCleanupExecuteStatus().toString()));
            return JobRunnerResponse.failed((Throwable)e);
        }
        this.hostApp.setJsmCleanupExecuteStatus(CleanupStatus.SUCCESS);
        log.info(String.format("JsmCleanup: Scheduled run succeeded, current CleanupStatus is %s", this.hostApp.getJsmCleanupExecuteStatus().toString()));
        return JobRunnerResponse.success();
    }
}

